/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.entity.model;

import cofh.lib.util.helpers.MathHelper;
import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class BlizzModel<T extends LivingEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation BLIZZ_LAYER = new ModelLayerLocation(new ResourceLocation("thermal:blizz"), "main");
    private static final int CUBES = 4;
    private final ModelPart root;
    private final ModelPart[] topCubes;
    private final ModelPart[] botCubes;
    private final ModelPart head;

    public BlizzModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.topCubes = new ModelPart[4];
        this.botCubes = new ModelPart[4];
        Arrays.setAll(this.topCubes, num -> root.m_171324_("cube_top_" + num));
        Arrays.setAll(this.botCubes, num -> root.m_171324_("cube_bot_" + num));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.5f, -4.0f, -4.0f, 9.0f, 8.0f, 8.0f).m_171514_(0, 16).m_171481_(-4.5f, -4.0f, -6.0f, 9.0f, 4.0f, 2.0f), PartPose.f_171404_);
        CubeListBuilder topCube = CubeListBuilder.m_171558_().m_171514_(34, 8).m_171481_(-2.0f, 8.0f, -2.0f, 4.0f, 4.0f, 4.0f);
        CubeListBuilder botcube = CubeListBuilder.m_171558_().m_171514_(34, 2).m_171481_(-2.0f, 17.0f, -2.0f, 3.0f, 3.0f, 3.0f);
        for (int i = 0; i < 4; ++i) {
            partdefinition.m_171599_("cube_top_" + i, topCube, PartPose.f_171404_);
            partdefinition.m_171599_("cube_bot_" + i, botcube, PartPose.f_171404_);
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float x = MathHelper.bevel((float)(ageInTicks * 0.05f));
        float z = MathHelper.bevel((float)(ageInTicks * 0.05f + 1.0f));
        for (int i = 0; i < 4; ++i) {
            this.topCubes[i].f_104200_ = x * -4.0f;
            this.topCubes[i].f_104202_ = z * 4.0f;
            this.topCubes[i].f_104201_ = MathHelper.sin((float)(ageInTicks * 0.2f + (float)(i * 4)));
            this.botCubes[i].f_104200_ = x * 3.5f;
            this.botCubes[i].f_104202_ = z * 3.5f;
            this.botCubes[i].f_104201_ = MathHelper.sin((float)(ageInTicks * 0.2f + (float)(i * 4) + 2.0f));
            float temp = -x;
            x = z;
            z = temp;
        }
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }
}

